<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('description', 255);
			$table->string('path', 255);
			$table->string('type', 255);
			$table->integer('order');
			$table->integer('size');
			$table->boolean('is_main');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}