<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('korisnici', function(Blueprint $table) {
			$table->foreign('id_grupe')->references('id')->on('grupe_korisnika')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('korisnici', function(Blueprint $table) {
			$table->foreign('id_role_grupe')->references('id')->on('permisije_grupa')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transakcije', function(Blueprint $table) {
			$table->foreign('id_korisnika')->references('id')->on('korisnici')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transakcije', function(Blueprint $table) {
			$table->foreign('id_statusa')->references('id')->on('statusi_tranasakcija')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permisije_grupa', function(Blueprint $table) {
			$table->foreign('id_grupe')->references('id')->on('grupe_korisnika')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permisije_grupa', function(Blueprint $table) {
			$table->foreign('id_permisije')->references('id')->on('permisije')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('podaci_ostalo', function(Blueprint $table) {
			$table->foreign('id_predemta')->references('id')->on('predmeti_transakcija')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('korisnici', function(Blueprint $table) {
			$table->dropForeign('korisnici_id_grupe_foreign');
		});
		Schema::table('korisnici', function(Blueprint $table) {
			$table->dropForeign('korisnici_id_role_grupe_foreign');
		});
		Schema::table('transakcije', function(Blueprint $table) {
			$table->dropForeign('transakcije_id_korisnika_foreign');
		});
		Schema::table('transakcije', function(Blueprint $table) {
			$table->dropForeign('transakcije_id_statusa_foreign');
		});
		Schema::table('permisije_grupa', function(Blueprint $table) {
			$table->dropForeign('permisije_grupa_id_grupe_foreign');
		});
		Schema::table('permisije_grupa', function(Blueprint $table) {
			$table->dropForeign('permisije_grupa_id_permisije_foreign');
		});
		Schema::table('podaci_ostalo', function(Blueprint $table) {
			$table->dropForeign('podaci_ostalo_id_predemta_foreign');
		});
	}
}