<?php

namespace GroupPermission;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GroupPermission extends Eloquent {

	protected $table = 'permisije_grupa';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('UserGroup');
	}

	public function permission()
	{
		return $this->belongsTo('Permission');
	}

}