<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar');
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->string('description_en')->nullable();
			$table->string('description_ar')->nullable();
			$table->boolean('show_product')->nullable()->default(0);
			$table->integer('uses')->nullable();
			$table->enum('discount_type', array('fixed', 'percent'))->nullable();
			$table->integer('amount')->nullable();
			$table->enum('to_buy', array('any_service', 'custom', 'n_services'))->nullable();
			$table->enum('to_get', array('any_service', 'any_product', 'any_all', 'custom'))->nullable();
			$table->integer('n_services')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}