<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->index();
			$table->integer('tenant_id')->unsigned()->index();
			$table->tinyInteger('sell_type')->index();
			$table->decimal('price');
			$table->decimal('tax');
			$table->decimal('discount_amount', 3,1)->default('0');
			$table->string('image');
			$table->tinyInteger('quantity')->nullable();
			$table->tinyInteger('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}