<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantsTable extends Migration {

	public function up()
	{
		Schema::create('tenants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('owner_id')->unsigned()->index();
			$table->integer('tanent_type_id')->unsigned()->index();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->tinyInteger('is_vendor')->index();
			$table->tinyInteger('is_supplier')->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tenants');
	}
}