<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientTable extends Migration {

	public function up()
	{
		Schema::create('patient', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('has_requested_vaccine')->default(False);
			$table->longText('qr_code_link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('patient');
	}
}