<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('patient', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('patient')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vaccination_date_slot', function(Blueprint $table) {
			$table->foreign('vaccine_id')->references('id')->on('vaccine')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vaccination_date_slot', function(Blueprint $table) {
			$table->foreign('vaccination_location_id')->references('id')->on('vaccinication_center')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('document', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assigned_vaccination_slot', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assigned_vaccination_slot', function(Blueprint $table) {
			$table->foreign('vaccination_time_slot_id')->references('id')->on('vaccination_time_slot')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medical_history', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ceir_detail', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patient_vaccination_detail', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patient_vaccination_detail', function(Blueprint $table) {
			$table->foreign('vaccination_time_slot')->references('id')->on('vaccination_time_slot')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('patient', function(Blueprint $table) {
			$table->dropForeign('patient_user_id_foreign');
		});
		Schema::table('vaccination_date_slot', function(Blueprint $table) {
			$table->dropForeign('vaccination_date_slot_vaccine_id_foreign');
		});
		Schema::table('vaccination_date_slot', function(Blueprint $table) {
			$table->dropForeign('vaccination_date_slot_vaccination_location_id_foreign');
		});
		Schema::table('document', function(Blueprint $table) {
			$table->dropForeign('document_patient_id_foreign');
		});
		Schema::table('assigned_vaccination_slot', function(Blueprint $table) {
			$table->dropForeign('assigned_vaccination_slot_patient_id_foreign');
		});
		Schema::table('assigned_vaccination_slot', function(Blueprint $table) {
			$table->dropForeign('assigned_vaccination_slot_vaccination_time_slot_id_foreign');
		});
		Schema::table('medical_history', function(Blueprint $table) {
			$table->dropForeign('medical_history_patient_id_foreign');
		});
		Schema::table('ceir_detail', function(Blueprint $table) {
			$table->dropForeign('ceir_detail_patient_id_foreign');
		});
		Schema::table('patient_vaccination_detail', function(Blueprint $table) {
			$table->dropForeign('patient_vaccination_detail_patient_id_foreign');
		});
		Schema::table('patient_vaccination_detail', function(Blueprint $table) {
			$table->dropForeign('patient_vaccination_detail_vaccination_time_slot_foreign');
		});
	}
}