<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->string('priority', 50)->nullable();
			$table->integer('ticket_category_id')->unsigned()->nullable();
			$table->string('src', 100)->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}