<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DR extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;
    protected $fillable = array('client', 'blood_type_id', 'age', 'bags_num', 'latitude', 'city_id', 'phone', 'hospital', 'notes', 'client_id');

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function clientRequest()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function notification()
    {
        return $this->hasMany('Notification', 'donation_request_id');
    }

}