<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('user_id');
			$table->string('responsible_person')->nullable();
			$table->string('phone')->nullable();
			$table->string('address', 255)->nullable();
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->string('brands', 255)->nullable();
			$table->string('file', 255)->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('status', 255)->nullable();
			$table->integer('rating')->nullable()->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}