<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('m_materi', function(Blueprint $table) {
			$table->foreign('id_jenis')->references('id_jenis_materi')->on('m_jenis_materi')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('m_materi', function(Blueprint $table) {
			$table->foreign('id_user')->references('id_user')->on('m_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('m_pertanyaan', function(Blueprint $table) {
			$table->foreign('id_materi')->references('id_materi')->on('m_materi')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('m_jawaban', function(Blueprint $table) {
			$table->foreign('id_pertanyaan')->references('id_pertanyaan')->on('m_pertanyaan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_exam', function(Blueprint $table) {
			$table->foreign('id_user_participant')->references('id_user')->on('m_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_exam', function(Blueprint $table) {
			$table->foreign('id_materi')->references('id_materi')->on('m_materi')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->foreign('id_t_exam')->references('id_t_exam')->on('t_exam')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->foreign('id_pertanyaan')->references('id_pertanyaan')->on('m_pertanyaan')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->foreign('id_jawaban_user')->references('id_jawaban')->on('m_jawaban')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('m_materi', function(Blueprint $table) {
			$table->dropForeign('m_materi_id_jenis_foreign');
		});
		Schema::table('m_materi', function(Blueprint $table) {
			$table->dropForeign('m_materi_id_user_foreign');
		});
		Schema::table('m_pertanyaan', function(Blueprint $table) {
			$table->dropForeign('m_pertanyaan_id_materi_foreign');
		});
		Schema::table('m_jawaban', function(Blueprint $table) {
			$table->dropForeign('m_jawaban_id_pertanyaan_foreign');
		});
		Schema::table('t_exam', function(Blueprint $table) {
			$table->dropForeign('t_exam_id_user_participant_foreign');
		});
		Schema::table('t_exam', function(Blueprint $table) {
			$table->dropForeign('t_exam_id_materi_foreign');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->dropForeign('t_detail_exam_id_t_exam_foreign');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->dropForeign('t_detail_exam_id_pertanyaan_foreign');
		});
		Schema::table('t_detail_exam', function(Blueprint $table) {
			$table->dropForeign('t_detail_exam_id_jawaban_user_foreign');
		});
	}
}