<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('token_book', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('toilet_inventory', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('toilet_inventory', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('grievance', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('grievance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->foreign('attendance_id')->references('id')->on('attendance')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->foreign('session_id')->references('id')->on('session')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->foreign('session_id')->references('id')->on('session')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('token_book')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->foreign('session_id')->references('id')->on('session')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('toilet_user', function(Blueprint $table) {
			$table->foreign('toilet_id')->references('id')->on('toilet')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('toilet_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('token_book', function(Blueprint $table) {
			$table->dropForeign('token_book_toilet_id_foreign');
		});
		Schema::table('toilet_inventory', function(Blueprint $table) {
			$table->dropForeign('toilet_inventory_toilet_id_foreign');
		});
		Schema::table('toilet_inventory', function(Blueprint $table) {
			$table->dropForeign('toilet_inventory_product_id_foreign');
		});
		Schema::table('grievance', function(Blueprint $table) {
			$table->dropForeign('grievance_toilet_id_foreign');
		});
		Schema::table('grievance', function(Blueprint $table) {
			$table->dropForeign('grievance_user_id_foreign');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->dropForeign('sanitation_toilet_id_foreign');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->dropForeign('sanitation_user_id_foreign');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->dropForeign('sanitation_attendance_id_foreign');
		});
		Schema::table('sanitation', function(Blueprint $table) {
			$table->dropForeign('sanitation_session_id_foreign');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->dropForeign('income_toilet_id_foreign');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->dropForeign('income_user_id_foreign');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->dropForeign('income_session_id_foreign');
		});
		Schema::table('income', function(Blueprint $table) {
			$table->dropForeign('income_book_id_foreign');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->dropForeign('attendance_toilet_id_foreign');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->dropForeign('attendance_user_id_foreign');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->dropForeign('attendance_session_id_foreign');
		});
		Schema::table('toilet_user', function(Blueprint $table) {
			$table->dropForeign('toilet_user_toilet_id_foreign');
		});
		Schema::table('toilet_user', function(Blueprint $table) {
			$table->dropForeign('toilet_user_user_id_foreign');
		});
	}
}