<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('manpower_id')->unsigned();
			$table->string('addressType', 150);
			$table->string('house', 50);
			$table->string('village', 50);
			$table->string('union', 50);
			$table->string('postOffice', 50);
			$table->integer('postalCode');
			$table->string('district', 50);
			$table->string('upozila', 50);
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}