<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApprovedProjectsTable extends Migration {

	public function up()
	{
		Schema::create('approved_projects', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tender_id')->unsigned();
			$table->string('contact_person_name')->nullable();
			$table->string('contact_person_email')->nullable();
			$table->string('contact_person_phone')->nullable();
			$table->string('contact_person_designation')->nullable();
			$table->string('project_cost');
			$table->string('financial_year');
			$table->string('work_duration')->nullable();
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->mediumInteger('total_manpower')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('approved_projects');
	}
}