<?php

namespace App\Models\Account;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ExchangeAccount extends Eloquent {

	protected $table = 'exchange_accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'account_name', 'api_key', 'api_secret', 'exchange_id', 'competition_count');

	public function exchange()
	{
		return $this->belongsTo('Exchange');
	}

	public function account()
	{
		return $this->belongsTo('Account');
	}

}