<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('violations', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('violations', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_game_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_user_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_account_id_foreign');
		});
		Schema::table('violations', function(Blueprint $table) {
			$table->dropForeign('violations_manager_id_foreign');
		});
		Schema::table('violations', function(Blueprint $table) {
			$table->dropForeign('violations_player_id_foreign');
		});
	}
}