<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormInputsTable extends Migration {

	public function up()
	{
		Schema::create('form_inputs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('form_id')->unsigned();
			$table->string('input_name');
			$table->enum('input_type', array('text', 'textarea', 'phone', 'tele', 'file', 'email'));
			$table->string('input_lable');
			$table->string('input_placeholder')->nullable();
			$table->boolean('is_required')->default(1);
			$table->mediumInteger('sort');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('form_inputs');
	}
}