<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('short_description');
			$table->string('description');
			$table->enum('job_type', array('full_time', 'part_time'));
			$table->enum('remote', array('on_site', 'hybrid', 'remote'));
			$table->string('location');
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('section_id')->unsigned();
			$table->timestamp('published_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}