<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetadataTable extends Migration {

	public function up()
	{
		Schema::create('metadata', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('page_id')->unsigned();
			$table->string('title');
			$table->string('description');
			$table->json('keywords')->nullable();
			$table->string('og_title')->nullable();
			$table->string('og_description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('metadata');
	}
}