<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Meeting extends Eloquent {

	protected $table = 'meetings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'employee_id', 'meeting_date', 'meeting_room_id', 'type', 'note', 'status');

	public function employees()
	{
		return $this->belongsToMany('App\Modules\HR\Entities\Employee');
	}

	public function meetingRoom()
	{
		return $this->belongsTo('App\Modules\Secretariat\Entities\MeetingRoom');
	}

	public function MeetingDiscussionPoint()
	{
		return $this->hasMany('App\Modules\Secretariat\Entities\MeetingDiscussionPoint');
	}

	public function meetingDecisions()
	{
		return $this->hasMany('App\Modules\Secretariat\Entities\MeetingDecision');
	}

}