<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceSamplesTable extends Migration {

	public function up()
	{
		Schema::create('service_samples', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 300);
			$table->text('description')->nullable();
			$table->float('order')->default('1');
			$table->integer('media_id')->unsigned();
			$table->boolean('is_featured')->default(false);
			$table->integer('service_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('service_samples');
	}
}