<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblCarsTable extends Migration {

	public function up()
	{
		Schema::create('tbl_cars', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('car_brand_id')->unsigned();
			$table->string('car_model', 255);
			$table->integer('city_id')->unsigned();
			$table->integer('plate_number')->unique();
			$table->string('driving_license_imge', 255)->nullable();
			$table->string('car_plate_img', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tbl_cars');
	}
}