<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTblTripsTable extends Migration {

	public function up()
	{
		Schema::create('tbl_trips', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('orginized_id')->unsigned();
			$table->double('start_point')->nullable();
			$table->double('end_point')->nullable();
			$table->time('go_time')->nullable();
			$table->time('return_time')->nullable();
			$table->string('chairs_num');
			$table->enum('appearance', array('public', 'private'))->nullable();
			$table->enum('passenger_type', array('male', 'femal', 'all'))->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->enum('back_status', array('yes', 'no'))->nullable();
			$table->string('trip_title')->nullable();
			$table->bigInteger('trip_code');
			$table->timestamps();
			$table->integer('distance')->nullable();
			$table->bigInteger('kilo_share');
		});
	}

	public function down()
	{
		Schema::drop('tbl_trips');
	}
}