<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function branch()
    {
        return $this->hasMany('DoctorBranch');
    }

    public function room()
    {
        return $this->hasMany('RoomService');
    }

}