<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TreatmentPlan extends Model 
{

    protected $table = 'treatment_plans';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function doctor()
    {
        return $this->belongsTo('User', 'doctor_id');
    }

    public function reservation()
    {
        return $this->belongsTo('Reservation', 'reservation_id');
    }

    public function service()
    {
        return $this->hasMany('TreatmentPlanService');
    }

}