<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function information()
    {
        return $this->hasMany('UserInformation');
    }

    public function medication()
    {
        return $this->hasMany('Medication');
    }

    public function treatmentPlan()
    {
        return $this->hasMany('TreatmentPlan');
    }

}