<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandTable extends Migration {

	public function up()
	{
		Schema::create('brand', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('logo');
			$table->enum('is_active', array(''));
			$table->string('meta_title');
			$table->string('meta_desc');
			$table->string('meta_keyword');
		});
	}

	public function down()
	{
		Schema::drop('brand');
	}
}