<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProvidersTable extends Migration {

	public function up()
	{
		Schema::create('service_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->integer('address_id')->unsigned();
			$table->string('www');
			$table->string('email');
			$table->string('phone');
			$table->string('longitude');
			$table->string('latitude');
			$table->integer('notification_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service_providers');
	}
}