<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesTable extends Migration {

	public function up()
	{
		Schema::create('candidates', function(Blueprint $table) {
			$table->increments('id');
			$table->date('application_date');
			$table->string('full_name');
			$table->integer('position_id');
			$table->string('cv_filename');
			$table->string('phone_number');
			$table->string('email');
			$table->integer('fit_id');
			$table->integer('salary');
			$table->string('start_date');
			$table->integer('language_leve_id')->unsigned();
			$table->integer('stage_id');
			$table->text('comments');
			$table->boolean('cancelled');
		});
	}

	public function down()
	{
		Schema::drop('candidates');
	}
}