<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAircraftsTable extends Migration {

	public function up()
	{
		Schema::create('aircrafts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 3)->index();
			$table->string('name', 255);
			$table->bigInteger('aircraft_id')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('aircrafts');
	}
}