<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsTable extends Migration {

	public function up()
	{
		Schema::create('clubs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('area_id')->unsigned();
			$table->string('name');
			$table->text('description')->nullable();
			$table->date('since');
		});
	}

	public function down()
	{
		Schema::drop('clubs');
	}
}