<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('county')->unsigned();
			$table->string('company_name', 256)->unique();
			$table->string('company_address_2', 256)->nullable();
			$table->string('company_city', 128);
			$table->string('company_state', 2);
			$table->integer('company_county_id')->unsigned();
			$table->enum('company_number_employees', array('Under10', '11-50', '50-150', 'Over150'));
			$table->integer('business_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}