<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('contact_first_name', 50)->nullable()->index();
			$table->string('contact_last_name', 50)->index();
			$table->string('contact_title', 50)->index();
			$table->char('contact_email', 80)->nullable()->index();
			$table->string('contactable_type', 25);
			$table->integer('contactable_id');
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}