<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('inquiry_id')->references('id')->on('inquiries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->foreign('county_id')->references('id')->on('counties')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->foreign('county_user_role')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('county')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('company_county_id')->references('id')->on('counties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('business_type_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiries', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_insurance', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->foreign('company_user_role')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_profiles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_profiles', function(Blueprint $table) {
			$table->foreign('company_city_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->foreign('inquiry_id')->references('id')->on('inquiries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->foreign('milestone_id')->references('id')->on('milestones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->foreign('contact_type_id')->references('id')->on('contact_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->foreign('inquiry_id')->references('id')->on('inquiries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->foreign('notification_frequency_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('internal_company_profiles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->foreign('service_provider')->references('id')->on('service_providers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->foreign('inquiry_id')->references('id')->on('inquiries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('internal_company_profile_revenues', function(Blueprint $table) {
			$table->foreign('internal_company_profile_id')->references('id')->on('internal_company_profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('county_id')->references('id')->on('counties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_county', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_county', function(Blueprint $table) {
			$table->foreign('county_id')->references('id')->on('counties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiry_answers', function(Blueprint $table) {
			$table->foreign('inquiry_id')->references('id')->on('inquiries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inquiry_answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->foreign('phone_type_id')->references('id')->on('phone_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_inquiry_id_foreign');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->dropForeign('county_user_county_id_foreign');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->dropForeign('county_user_user_id_foreign');
		});
		Schema::table('county_user', function(Blueprint $table) {
			$table->dropForeign('county_user_county_user_role_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_county_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_company_county_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_business_type_id_foreign');
		});
		Schema::table('inquiries', function(Blueprint $table) {
			$table->dropForeign('inquiries_company_id_foreign');
		});
		Schema::table('company_insurance', function(Blueprint $table) {
			$table->dropForeign('company_insurance_company_id_foreign');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->dropForeign('company_user_company_id_foreign');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->dropForeign('company_user_user_id_foreign');
		});
		Schema::table('company_user', function(Blueprint $table) {
			$table->dropForeign('company_user_company_user_role_foreign');
		});
		Schema::table('company_profiles', function(Blueprint $table) {
			$table->dropForeign('company_profiles_company_id_foreign');
		});
		Schema::table('company_profiles', function(Blueprint $table) {
			$table->dropForeign('company_profiles_company_city_id_foreign');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->dropForeign('inquiry_milestone_inquiry_id_foreign');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->dropForeign('inquiry_milestone_milestone_id_foreign');
		});
		Schema::table('inquiry_milestone', function(Blueprint $table) {
			$table->dropForeign('inquiry_milestone_contact_type_id_foreign');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->dropForeign('notification_recipients_inquiry_id_foreign');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->dropForeign('notification_recipients_user_id_foreign');
		});
		Schema::table('notification_recipients', function(Blueprint $table) {
			$table->dropForeign('notification_recipients_notification_frequency_id_foreign');
		});
		Schema::table('internal_company_profiles', function(Blueprint $table) {
			$table->dropForeign('internal_company_profiles_company_id_foreign');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->dropForeign('service_providers_service_id_foreign');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->dropForeign('company_service_service_provider_foreign');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->dropForeign('company_service_inquiry_id_foreign');
		});
		Schema::table('company_service', function(Blueprint $table) {
			$table->dropForeign('company_service_service_id_foreign');
		});
		Schema::table('internal_company_profile_revenues', function(Blueprint $table) {
			$table->dropForeign('internal_company_profile_revenues_internal_company_profile_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_county_id_foreign');
		});
		Schema::table('city_county', function(Blueprint $table) {
			$table->dropForeign('city_county_city_id_foreign');
		});
		Schema::table('city_county', function(Blueprint $table) {
			$table->dropForeign('city_county_county_id_foreign');
		});
		Schema::table('inquiry_answers', function(Blueprint $table) {
			$table->dropForeign('inquiry_answers_inquiry_id_foreign');
		});
		Schema::table('inquiry_answers', function(Blueprint $table) {
			$table->dropForeign('inquiry_answers_question_id_foreign');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->dropForeign('phone_numbers_phone_type_id_foreign');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->dropForeign('phone_numbers_contact_id_foreign');
		});
	}
}