<?php

namespace App\Models;

class Contacts extends Eloquent {

	protected $table = 'contacts';
	public $timestamps = true;
	protected $fillable = array('contact_first_name', 'contact_last_name', 'contact_title', 'contact_email', 'contactable_type');
	protected $visible = array('contact_first_name', 'contact_last_name', 'contact_title', 'contact_email', 'contactable_type');

	public function contactable()
	{
		return $this->morphTo();
	}

	public function phone_numbers()
	{
		return $this->hasMany('App\Models\PhoneNumber', 'contact_id');
	}

}