<?php

namespace App\Models;

class InternalCompanyProfile extends Eloquent {

	protected $table = 'internal_company_profiles';
	public $timestamps = true;
	protected $fillable = array('company_id');
	protected $visible = array('company_id');

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function contacts()
	{
		return $this->morphMany('App\Models\Contacts', 'contactable');
	}

	public function revenues()
	{
		return $this->hasMany('App\Models\InternalCompanyProfileRevenue', 'internal_company_profile_id');
	}

}