<?php

namespace App\Models;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;
	protected $fillable = array('notification_text', 'user_id', 'notification_read', 'inquiry_id');
	protected $visible = array('notification_text', 'user_id', 'notification_read', 'inquiry_id');

	public function inquiry()
	{
		return $this->belongsTo('Inquiry', 'inquiry_id');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

}