<?php

namespace App\Models;

class ServiceProvider extends Eloquent {

	protected $table = 'service_providers';
	public $timestamps = true;
	protected $fillable = array('service_provider_name');
	protected $visible = array('service_provider_name');

	public function service()
	{
		return $this->belongsToMany('App\Models\Service');
	}

	public function contacts()
	{
		return $this->morphMany('App\Models\Contacts', 'contactable');
	}

	public function company_service()
	{
		return $this->hasMany('App\Models\CompanyService');
	}

}