<?php

namespace app\Models\Tenants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Organization extends Eloquent {

	protected $table = 'organizations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');
	protected $visible = array('user_id');

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

}