<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'middle_name', 'last_name', 'suffix', 'preferred_name', 'email', 'designation_id', 'profile_picture', 'mobile', 'ssn', 'dob', 'status');
	protected $visible = array('first_name', 'middle_name', 'last_name', 'suffix', 'preferred_name', 'email', 'designation_id', 'profile_picture', 'mobile', 'ssn', 'dob', 'status');

	public function designation()
	{
		return $this->hasOne('App\Models\Tenants\Designation', 'designation_id');
	}

}