<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 255);
			$table->integer('city_id');
			$table->string('password', 255);
			$table->string('pin_code', 255)->nullable();
			$table->datetime('pin_code_date_expired')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}