<?php

namespace Models;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;
	protected $fillable = array('body', 'user_id', 'auction_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function auction()
	{
		return $this->belongsTo('Models\Auction', 'auction_id');
	}

	public function reports()
	{
		return $this->hasMany('Models\Report', 'comment_id');
	}

}