<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('category_id')->unsigned()->nullable();
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('slug')->unique();
			$table->bigInteger('language_id')->unsigned()->index();
			$table->text('image')->nullable();
			$table->enum('level', array('all', 'beginner', 'intermediate', 'advanced'));
			$table->boolean('published')->default(false);
			$table->boolean('approved')->default(false);
			$table->text('requirements');
			$table->bigInteger('sub_category_id')->unsigned();
			$table->string('duration')->nullable();
			$table->boolean('free');
			$table->string('meta_keywords')->nullable();
			$table->text('meta_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}