<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('course_id')->unsigned();
			$table->bigInteger('section_id')->unsigned();
			$table->string('title');
			$table->text('description')->nullable();
			$table->enum('content_type', array('video', 'youtube', 'article'));
			$table->boolean('preview')->default(false);
			$table->decimal('duration')->default('0');
			$table->boolean('privacy')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}