<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCertificatesTable extends Migration {

	public function up()
	{
		Schema::create('certificates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->string('certificate_no')->unique();
			$table->string('course_title');
			$table->string('video_hours');
		});
	}

	public function down()
	{
		Schema::drop('certificates');
	}
}