<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('commentable_id')->unsigned();
			$table->string('commentable_type');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('parent_id')->unsigned()->nullable();
			$table->text('body');
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}