<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultationsTable extends Migration {

	public function up()
	{
		Schema::create('consultations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unique()->unsigned();
			$table->text('about')->nullable();
			$table->string('days')->nullable();
			$table->string('available_time')->nullable();
			$table->integer('rate_hour')->nullable();
			$table->string('minute_rate')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('consultations');
	}
}