<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('title');
			$table->string('slug')->unique();
			$table->text('meta_description')->nullable();
			$table->text('body');
			$table->string('featured_image')->nullable();
			$table->boolean('published')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}