<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentCardsTable extends Migration {

	public function up()
	{
		Schema::create('payment_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('bank_name')->nullable();
			$table->string('bank_account_type')->nullable();
			$table->bigInteger('account_number');
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('payment_cards');
	}
}